/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.SimplePlanesMod;
import xyz.przemyk.simpleplanes.client.PlaneSound;
import xyz.przemyk.simpleplanes.container.RemoveUpgradesContainer;
import xyz.przemyk.simpleplanes.network.PlaneNetworking;
import xyz.przemyk.simpleplanes.network.RotationPacket;
import xyz.przemyk.simpleplanes.network.SUpgradeRemovedPacket;
import xyz.przemyk.simpleplanes.network.UpdateUpgradePacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class PlaneEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final DataParameter<Integer> MAX_HEALTH = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> HEALTH = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> MAX_SPEED = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<String> MATERIAL = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Integer> ROCKING_TICKS = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> TIME_SINCE_HIT = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> DAMAGE_TAKEN = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> PARKED = EntityDataManager.func_187226_a(PlaneEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Quaternion> Q = EntityDataManager.func_187226_a(PlaneEntity.class, SimplePlanesDataSerializers.QUATERNION_SERIALIZER);
    public Quaternion Q_Client = new Quaternion(Quaternion.field_227060_a_);
    public Quaternion Q_Prev = new Quaternion(Quaternion.field_227060_a_);
    private int onGroundTicks;
    public HashMap<ResourceLocation, Upgrade> upgrades = new HashMap();
    public EngineUpgrade engineUpgrade = null;
    public float rotationRoll;
    public float prevRotationRoll;
    private float deltaRotation;
    private float deltaRotationLeft;
    private int deltaRotationTicks;
    private Block planksMaterial;
    public boolean mountMessage;
    private int damageTimeout;
    public int notMovingTime;
    public int goldenHeartsTimeout = 0;
    private final int networkUpdateInterval;
    public static final ResourceLocation FIREPROOF_MATERIALS = new ResourceLocation("simpleplanes", "fireproof_materials");
    private int lerpSteps;
    private int lerpStepsQ;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private boolean rocking;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    private static final TempMotionVars TEMP_MOTION_VARS = new TempMotionVars();

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, World worldIn) {
        this(entityTypeIn, worldIn, Blocks.field_196662_n);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, World worldIn, Block material) {
        super(entityTypeIn, worldIn);
        this.networkUpdateInterval = entityTypeIn.func_220332_l();
        this.field_70138_W = 0.9999f;
        this.setMaterial(material);
        this.setMaxSpeed(1.0f);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, World worldIn, Block material, double x, double y, double z) {
        this(entityTypeIn, worldIn, material);
        this.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MAX_HEALTH, (Object)10);
        this.field_70180_af.func_187214_a(HEALTH, (Object)10);
        this.field_70180_af.func_187214_a(Q, (Object)Quaternion.field_227060_a_);
        this.field_70180_af.func_187214_a(MAX_SPEED, (Object)Float.valueOf(0.25f));
        this.field_70180_af.func_187214_a(MATERIAL, (Object)Blocks.field_196662_n.getRegistryName().toString());
        this.field_70180_af.func_187214_a(ROCKING_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(TIME_SINCE_HIT, (Object)0);
        this.field_70180_af.func_187214_a(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(PARKED, (Object)true);
    }

    public float getMaxSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue();
    }

    public void setMaxSpeed(float maxSpeed) {
        this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public Quaternion getQ() {
        return new Quaternion((Quaternion)this.field_70180_af.func_187225_a(Q));
    }

    public void setQ(Quaternion q) {
        this.field_70180_af.func_187227_b(Q, (Object)q);
    }

    public Quaternion getQ_Client() {
        return new Quaternion(this.Q_Client);
    }

    public void setQ_Client(Quaternion q) {
        this.Q_Client = q;
    }

    public Quaternion getQ_Prev() {
        return this.Q_Prev.func_227068_g_();
    }

    public void setQ_prev(Quaternion q) {
        this.Q_Prev = q;
    }

    public Block getMaterial() {
        return this.planksMaterial;
    }

    public void setHealth(int health) {
        this.field_70180_af.func_187227_b(HEALTH, (Object)Math.max(health, 0));
    }

    public int getHealth() {
        return (Integer)this.field_70180_af.func_187225_a(HEALTH);
    }

    public int getMaxHealth() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_HEALTH);
    }

    public void setParked(Boolean val) {
        this.field_70180_af.func_187227_b(PARKED, (Object)val);
    }

    public boolean getParked() {
        return (Boolean)this.field_70180_af.func_187225_a(PARKED);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getItemStack();
    }

    public void setMaterial(String material) {
        this.field_70180_af.func_187227_b(MATERIAL, (Object)material);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(material));
        this.planksMaterial = block == null ? Blocks.field_196662_n : block;
    }

    public void setMaterial(Block material) {
        this.field_70180_af.func_187227_b(MATERIAL, (Object)material.getRegistryName().toString());
        this.planksMaterial = material;
    }

    public boolean isPowered() {
        return this.func_70089_S() && (this.isCreative() || this.engineUpgrade != null && this.engineUpgrade.isPowered());
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_225608_bj_() && itemStack.func_190926_b()) {
            boolean hasPlayer = false;
            for (Entity passenger : this.func_184188_bt()) {
                if (!(passenger instanceof PlayerEntity)) continue;
                hasPlayer = true;
                break;
            }
            if (!hasPlayer || ((Boolean)SimplePlanesConfig.THIEF.get()).booleanValue()) {
                this.func_184226_ay();
            }
            return ActionResultType.SUCCESS;
        }
        if (itemStack.func_77973_b() == SimplePlanesItems.WRENCH.get()) {
            if (!this.field_70170_p.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new SimpleNamedContainerProvider((id, inv, p) -> new RemoveUpgradesContainer(id, this.func_145782_y()), StringTextComponent.field_240750_d_), buf -> buf.func_150787_b(this.func_145782_y()));
                return ActionResultType.CONSUME;
            }
            return ActionResultType.SUCCESS;
        }
        if (this.tryToAddUpgrade(player, itemStack)) {
            return ActionResultType.SUCCESS;
        }
        if (!this.field_70170_p.field_72995_K) {
            return player.func_184220_m((Entity)this) ? ActionResultType.CONSUME : ActionResultType.FAIL;
        }
        return player.func_184208_bv() == this.func_184208_bv() ? ActionResultType.FAIL : ActionResultType.SUCCESS;
    }

    protected boolean tryToAddUpgrade(PlayerEntity playerEntity, ItemStack itemStack) {
        Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getUpgradeFromItem(itemStack.func_77973_b());
        return upgradeTypeOptional.map(upgradeType -> {
            if (this.canAddUpgrade((UpgradeType)((Object)upgradeType))) {
                Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                this.addUpgrade(playerEntity, itemStack, upgrade);
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected void addUpgrade(PlayerEntity playerEntity, ItemStack itemStack, Upgrade upgrade) {
        upgrade.onApply(itemStack, playerEntity);
        if (!playerEntity.func_184812_l_()) {
            itemStack.func_190918_g(1);
        }
        UpgradeType upgradeType = upgrade.getType();
        this.upgrades.put(upgradeType.getRegistryName(), upgrade);
        if (upgradeType.isEngine) {
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
        if (!this.field_70170_p.field_72995_K) {
            PlaneNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateUpgradePacket(upgrade.getType().getRegistryName(), this.func_145782_y(), (ServerWorld)this.field_70170_p, true));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean creativePlayer;
        this.setTimeSinceHit(20);
        this.setDamageTaken(this.getDamageTaken() + 10.0f * amount);
        if (this.func_180431_b(source) || this.damageTimeout > 0) {
            return false;
        }
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        int health = this.getHealth();
        if (health < 0) {
            return false;
        }
        health = (int)((float)health - amount);
        this.setHealth(health);
        this.damageTimeout = 10;
        boolean isPlayer = source.func_76346_g() instanceof PlayerEntity;
        boolean bl = creativePlayer = isPlayer && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
        if (creativePlayer || isPlayer && this.getDamageTaken() > 30.0f || health <= 0) {
            if (!creativePlayer) {
                if (source == SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH) {
                    this.explode();
                }
                if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.dropItem();
                }
            }
            this.func_70106_y();
        }
        return true;
    }

    private void explode() {
        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 5, 1.0, 1.0, 1.0, 2.0);
        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 10, 1.0, 1.0, 1.0, 1.0);
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, Explosion.Mode.NONE);
    }

    protected void dropItem() {
        ItemStack itemStack = this.getItemStack();
        this.func_199701_a_(itemStack).func_184224_h(true);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70071_h_() {
        Entity controllingPassenger;
        super.func_70071_h_();
        if (Double.isNaN(this.func_213322_ci().func_72433_c())) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.prevRotationRoll = this.rotationRoll;
        if (this.field_70170_p.field_72995_K && !this.func_184186_bw()) {
            this.tickLerp();
            this.func_213317_d(Vector3d.field_186680_a);
            this.tickDeltaRotation(this.getQ_Client());
            this.tickUpgrades();
            return;
        }
        this.func_70018_K();
        TempMotionVars tempMotionVars = this.getMotionVars();
        if (this.func_189652_ae()) {
            tempMotionVars.gravity = 0.0;
            tempMotionVars.maxLift = 0.0f;
            tempMotionVars.push = 0.0f;
            tempMotionVars.passiveEnginePush = 0.0f;
        }
        if ((controllingPassenger = this.func_184179_bs()) instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)controllingPassenger;
            tempMotionVars.moveForward = playerEntity.field_191988_bg;
            tempMotionVars.moveStrafing = playerEntity.field_70702_br;
        } else {
            tempMotionVars.moveForward = 0.0f;
            tempMotionVars.moveStrafing = 0.0f;
            this.func_70031_b(false);
        }
        tempMotionVars.turnThreshold = (double)((Integer)SimplePlanesConfig.TURN_THRESHOLD.get()).intValue() / 100.0;
        if ((double)Math.abs(tempMotionVars.moveForward) < tempMotionVars.turnThreshold) {
            tempMotionVars.moveForward = 0.0f;
        }
        if ((double)Math.abs(tempMotionVars.moveStrafing) < tempMotionVars.turnThreshold) {
            tempMotionVars.moveStrafing = 0.0f;
        }
        tempMotionVars.passengerSprinting = this.func_70051_ag();
        Quaternion q = this.field_70170_p.field_72995_K ? this.getQ_Client() : this.getQ();
        MathUtil.EulerAngles angelsOld = MathUtil.toEulerAngles(q).copy();
        Vector3d oldMotion = this.func_213322_ci();
        boolean parked = this.updateParkedState(tempMotionVars);
        if (this.field_70170_p.field_72995_K && this.isPowered() && !parked) {
            PlaneSound.tryToPlay(this);
        }
        if (this.func_213322_ci().func_72433_c() > 0.05) {
            q = this.tickRotateMotion(tempMotionVars, q, this.func_213322_ci());
        }
        boolean doPitch = true;
        if (this.getOnGround() || this.isOnWater()) {
            doPitch = this.tickOnGround(tempMotionVars);
        } else {
            --this.onGroundTicks;
            if (!tempMotionVars.passengerSprinting) {
                tempMotionVars.push = tempMotionVars.passiveEnginePush;
            }
        }
        if (doPitch) {
            this.tickPitch(tempMotionVars);
        }
        this.tickMotion(tempMotionVars);
        this.tickRotation(tempMotionVars);
        this.tickUpgrades();
        if (this.onGroundTicks > -50 && oldMotion.func_72433_c() < 0.002 && this.func_213322_ci().func_72433_c() < 0.002) {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        this.updateRocking();
        this.func_226264_Z_();
        if (!this.field_70122_E || PlaneEntity.func_213296_b((Vector3d)this.func_213322_ci()) > (double)1.0E-5f || (this.field_70173_aa + this.func_145782_y()) % 4 == 0) {
            double speedAfter;
            double speedDiff;
            float f2;
            double speedBefore = Math.sqrt(PlaneEntity.func_213296_b((Vector3d)this.func_213322_ci()));
            boolean onGroundOld = this.field_70122_E;
            Vector3d motion = this.func_213322_ci();
            if (motion.func_189985_c() > 0.25 || tempMotionVars.moveForward != 0.0f) {
                this.field_70122_E = true;
            }
            this.func_213315_a(MoverType.SELF, motion);
            boolean bl = this.field_70122_E = motion.func_82617_b() == 0.0 ? onGroundOld : this.field_70122_E;
            if (this.field_70123_F && !this.field_70170_p.field_72995_K && ((Boolean)SimplePlanesConfig.PLANE_CRASH.get()).booleanValue() && this.onGroundTicks <= 0 && (f2 = (float)((speedDiff = speedBefore - (speedAfter = Math.sqrt(PlaneEntity.func_213296_b((Vector3d)this.func_213322_ci())))) * 10.0 - 5.0)) > 5.0f) {
                this.crash(f2);
            }
        }
        q.func_195890_a(new Quaternion(Vector3f.field_229183_f_, (float)((double)this.rotationRoll - angelsOld.roll), true));
        q.func_195890_a(new Quaternion(Vector3f.field_229178_a_, (float)((double)this.field_70125_A - angelsOld.pitch), true));
        q.func_195890_a(new Quaternion(Vector3f.field_229181_d_, (float)((double)this.field_70177_z - angelsOld.yaw), true));
        q = MathUtil.normalizeQuaternion(q);
        this.setQ_prev(this.getQ_Client());
        this.setQ(q);
        this.tickDeltaRotation(q);
        if (this.field_70170_p.field_72995_K && this.func_184186_bw()) {
            this.setQ_Client(q);
            PlaneNetworking.INSTANCE.sendToServer((Object)new RotationPacket(this.getQ()));
        } else {
            ServerPlayerEntity player = (ServerPlayerEntity)this.getPlayer();
            if (player != null) {
                player.field_71135_a.field_184346_E = 0;
            }
        }
        if (this.damageTimeout > 0) {
            --this.damageTimeout;
        }
        if (this.field_70170_p.field_72995_K && this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.getHealth() > this.getMaxHealth() & this.goldenHeartsTimeout > (this.getOnGround() ? 300 : 100)) {
            this.setHealth(this.getHealth() - 1);
            this.goldenHeartsTimeout = 0;
        }
        if (this.goldenHeartsTimeout < 1000 && this.isPowered()) {
            ++this.goldenHeartsTimeout;
        }
        this.tickLerp();
    }

    public void tickUpgrades() {
        ArrayList upgradesToRemove = new ArrayList();
        ArrayList upgradesToUpdate = new ArrayList();
        this.upgrades.forEach((rl, upgrade) -> {
            upgrade.tick();
            if (upgrade.removed) {
                upgradesToRemove.add(rl);
            } else if (upgrade.updateClient && !this.field_70170_p.field_72995_K) {
                upgradesToUpdate.add(rl);
            }
        });
        for (ResourceLocation name : upgradesToRemove) {
            this.upgrades.remove(name);
        }
        if (this.field_70173_aa % this.networkUpdateInterval == 0) {
            for (ResourceLocation name : upgradesToUpdate) {
                PlaneNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateUpgradePacket(name, this.func_145782_y(), (ServerWorld)this.field_70170_p));
            }
        }
    }

    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.PLANE_FUEL_COST.get();
    }

    private boolean updateParkedState(TempMotionVars tempMotionVars) {
        Vector3d oldMotion = this.func_213322_ci();
        boolean parked = !(!this.isOnWater() && !this.func_233570_aj_() || !(oldMotion.func_72433_c() < 0.1) || tempMotionVars.passengerSprinting || tempMotionVars.moveStrafing != 0.0f || this.notMovingTime <= 20 || !this.field_70122_E && !this.isOnWater() || tempMotionVars.moveForward != 0.0f);
        this.setParked(parked);
        return parked;
    }

    protected TempMotionVars getMotionVars() {
        TEMP_MOTION_VARS.reset();
        PlaneEntity.TEMP_MOTION_VARS.maxPushSpeed = this.getMaxSpeed() * 10.0f;
        return TEMP_MOTION_VARS;
    }

    protected void tickDeltaRotation(Quaternion q) {
        MathUtil.EulerAngles angels1 = MathUtil.toEulerAngles(q);
        this.field_70125_A = (float)angels1.pitch;
        this.field_70177_z = (float)angels1.yaw;
        this.rotationRoll = (float)angels1.roll;
        float d = (float)MathUtil.wrapSubtractDegrees(this.field_70126_B, this.field_70177_z);
        if (this.rotationRoll >= 90.0f && this.prevRotationRoll <= 90.0f) {
            d = 0.0f;
        }
        int diff = 3;
        this.deltaRotationTicks = Math.min(10, Math.max((int)Math.abs(this.deltaRotationLeft) * 5, this.deltaRotationTicks));
        this.deltaRotationLeft = (float)((double)this.deltaRotationLeft * 0.7);
        this.deltaRotationLeft += d;
        this.deltaRotationLeft = MathHelper.func_76142_g((float)this.deltaRotationLeft);
        this.deltaRotation = Math.min(Math.abs(this.deltaRotationLeft), (float)diff) * Math.signum(this.deltaRotationLeft);
        this.deltaRotationLeft -= this.deltaRotation;
        if (!(this.deltaRotation > 0.0f)) {
            --this.deltaRotationTicks;
        }
    }

    protected void tickRotation(TempMotionVars tempMotionVars) {
        double turn;
        float f1 = 1.0f;
        float moveStrafing = tempMotionVars.moveStrafing;
        int yawdiff = 3;
        float roll = this.rotationRoll;
        if (MathUtil.degreesDifferenceAbs(this.field_70125_A, 0.0) < 45.0) {
            for (int i = 0; i < 360; i += 180) {
                if (!(MathHelper.func_203301_d((float)this.rotationRoll, (float)i) < 80.0f)) continue;
                roll = MathUtil.lerpAngle(0.1f * f1, this.rotationRoll, i);
                break;
            }
        }
        if (this.getOnGround() || this.isOnWater()) {
            turn = moveStrafing > 0.0f ? (double)yawdiff : (moveStrafing == 0.0f ? 0.0 : (double)(-yawdiff));
            this.rotationRoll = roll;
        } else if (MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0) > 30.0) {
            turn = moveStrafing > 0.0f ? (double)(-yawdiff) : (moveStrafing == 0.0f ? 0.0 : (double)yawdiff);
            this.rotationRoll = roll;
        } else {
            if (moveStrafing == 0.0f) {
                this.rotationRoll = MathUtil.lerpAngle180(0.2f, this.rotationRoll, 0.0f);
            } else if (moveStrafing > 0.0f) {
                this.rotationRoll = Math.min(this.rotationRoll + f1, 15.0f);
            } else if (moveStrafing < 0.0f) {
                this.rotationRoll = Math.max(this.rotationRoll - f1, -15.0f);
            }
            double rollOld = MathUtil.toEulerAngles((Quaternion)this.getQ()).roll;
            turn = MathUtil.degreesDifferenceAbs(rollOld, 0.0) < 90.0 ? MathHelper.func_151237_a((double)(rollOld * (double)tempMotionVars.yawMultiplayer), (double)(-yawdiff), (double)yawdiff) : MathHelper.func_151237_a((double)((180.0 - rollOld) * (double)tempMotionVars.yawMultiplayer), (double)(-yawdiff), (double)yawdiff);
            if (moveStrafing == 0.0f) {
                turn = 0.0;
            }
        }
        this.field_70177_z = (float)((double)this.field_70177_z - turn);
    }

    protected void tickMotion(TempMotionVars tempMotionVars) {
        Vector3d pushVec;
        if (!this.isPowered()) {
            tempMotionVars.push = 0.0f;
        }
        Vector3d motion = this.func_213322_ci();
        double speed = motion.func_72433_c();
        speed -= speed * speed * tempMotionVars.dragQuad + speed * tempMotionVars.dragMul + tempMotionVars.drag;
        if ((speed = Math.max(speed, 0.0)) > tempMotionVars.maxSpeed) {
            speed = MathHelper.func_219803_d((double)0.2, (double)speed, (double)tempMotionVars.maxSpeed);
        }
        if (speed == 0.0) {
            motion = Vector3d.field_186680_a;
        }
        if (motion.func_72433_c() > 0.0) {
            motion = motion.func_186678_a(speed / motion.func_72433_c());
        }
        if ((pushVec = new Vector3d(this.getTickPush(tempMotionVars))).func_72433_c() != 0.0 && motion.func_72433_c() > 0.1) {
            double dot = MathUtil.normalizedDotProduct(pushVec, motion);
            pushVec = pushVec.func_186678_a(MathHelper.func_151237_a((double)(1.0 - dot * speed / (tempMotionVars.maxPushSpeed * ((double)tempMotionVars.push + 0.05))), (double)0.0, (double)2.0));
        }
        motion = motion.func_178787_e(pushVec);
        motion = motion.func_72441_c(0.0, tempMotionVars.gravity, 0.0);
        this.func_213317_d(motion);
    }

    protected Vector3f getTickPush(TempMotionVars tempMotionVars) {
        return this.transformPos(new Vector3f(0.0f, 0.0f, tempMotionVars.push));
    }

    protected void tickPitch(TempMotionVars tempMotionVars) {
        float pitch = 0.0f;
        if (tempMotionVars.moveForward > 0.0f) {
            pitch = 1.3f;
        } else if (tempMotionVars.moveForward < 0.0f) {
            pitch = -1.3f;
        }
        this.field_70125_A += pitch;
    }

    protected boolean tickOnGround(TempMotionVars tempMotionVars) {
        this.notMovingTime = this.func_213322_ci().func_189985_c() < 0.01 && this.getOnGround() ? ++this.notMovingTime : 0;
        if (this.notMovingTime > 200 && this.getHealth() < this.getMaxHealth() && this.getPlayer() != null) {
            this.setHealth(this.getHealth() + 1);
            this.notMovingTime = 100;
        }
        boolean speedingUp = true;
        this.onGroundTicks = this.onGroundTicks < 0 ? 5 : --this.onGroundTicks;
        float pitch = this.getGroundPitch();
        if (this.isPowered() && tempMotionVars.moveForward > 0.0f || this.isOnWater()) {
            pitch = 0.0f;
        } else if (this.func_213322_ci().func_72433_c() > tempMotionVars.takeOffSpeed) {
            pitch /= 2.0f;
        }
        this.field_70125_A = MathUtil.lerpAngle(0.1f, this.field_70125_A, pitch);
        if (MathUtil.degreesDifferenceAbs(this.field_70125_A, 0.0) > 1.0 && this.func_213322_ci().func_72433_c() < 0.1) {
            tempMotionVars.push /= 5.0f;
        }
        if (this.func_213322_ci().func_72433_c() < tempMotionVars.takeOffSpeed) {
            speedingUp = false;
        }
        if (tempMotionVars.moveForward < 0.0f) {
            tempMotionVars.push = -tempMotionVars.groundPush;
        }
        if (!this.isPowered() || tempMotionVars.moveForward == 0.0f) {
            tempMotionVars.push = 0.0f;
        }
        BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
        float f = this.field_70170_p.func_180495_p(pos).getSlipperiness((IWorldReader)this.field_70170_p, pos, (Entity)this);
        tempMotionVars.dragMul *= (double)(20.0f * (3.0f - f));
        return speedingUp;
    }

    protected float getGroundPitch() {
        return 15.0f;
    }

    protected Quaternion tickRotateMotion(TempMotionVars tempMotionVars, Quaternion q, Vector3d motion) {
        float d;
        float yaw = MathUtil.getYaw(motion);
        float pitch = MathUtil.getPitch(motion);
        if (MathUtil.degreesDifferenceAbs(yaw, this.field_70177_z) > 5.0 && (this.getOnGround() || this.isOnWater())) {
            this.func_213317_d(motion.func_186678_a(0.98));
        }
        if ((d = (float)MathUtil.degreesDifferenceAbs(pitch, this.field_70125_A)) > 180.0f) {
            d -= 180.0f;
        }
        d /= 60.0f;
        d = Math.min(1.0f, d);
        d *= d;
        d = 1.0f - d;
        double speed = this.func_213322_ci().func_72433_c();
        double lift = Math.min(speed * tempMotionVars.liftFactor, (double)tempMotionVars.maxLift) * (double)d;
        double cosRoll = (1.0 + 4.0 * Math.max(Math.cos(Math.toRadians(MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0))), 0.0)) / 5.0;
        d = (float)((double)d * cosRoll);
        this.func_213317_d(MathUtil.rotationToVector(MathUtil.lerpAngle180(0.1f, yaw, this.field_70177_z), (double)MathUtil.lerpAngle180(tempMotionVars.pitchToMotion * d, pitch, this.field_70125_A) + (lift *= cosRoll), speed));
        if (!this.getOnGround() && !this.isOnWater() && motion.func_72433_c() > 0.1) {
            if (MathUtil.degreesDifferenceAbs(pitch, this.field_70125_A) > 90.0) {
                pitch = MathHelper.func_76142_g((float)(pitch + 180.0f));
            }
            if (Math.abs(this.field_70125_A) < 85.0f) {
                yaw = MathUtil.getYaw(this.func_213322_ci());
                if (MathUtil.degreesDifferenceAbs(yaw, this.field_70177_z) > 90.0) {
                    yaw -= 180.0f;
                }
                Quaternion q1 = MathUtil.toQuaternion(yaw, pitch, this.rotationRoll);
                q = MathUtil.lerpQ(tempMotionVars.motionToRotation, q, q1);
            }
        }
        return q;
    }

    public Vector3f transformPos(Vector3f relPos) {
        MathUtil.EulerAngles angels = MathUtil.toEulerAngles(this.getQ_Client());
        angels.yaw = -angels.yaw;
        angels.roll = -angels.roll;
        relPos.func_214905_a(MathUtil.toQuaternion(angels.yaw, angels.pitch, angels.roll));
        return relPos;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public void func_70037_a(CompoundNBT compound) {
        if (compound.func_74764_b("max_speed")) {
            this.field_70180_af.func_187227_b(MAX_SPEED, (Object)Float.valueOf(compound.func_74760_g("max_speed")));
        }
        if (compound.func_74764_b("max_health")) {
            int maxHealth = compound.func_74762_e("max_health");
            if (maxHealth <= 0) {
                maxHealth = 20;
            }
            this.field_70180_af.func_187227_b(MAX_HEALTH, (Object)maxHealth);
        }
        if (compound.func_74764_b("health")) {
            int health = compound.func_74762_e("health");
            if (health <= 0) {
                health = 1;
            }
            this.field_70180_af.func_187227_b(HEALTH, (Object)health);
        }
        if (compound.func_74764_b("material")) {
            this.setMaterial(compound.func_74779_i("material"));
        }
        if (compound.func_74764_b("upgrades")) {
            CompoundNBT upgradesNBT = compound.func_74775_l("upgrades");
            this.deserializeUpgrades(upgradesNBT);
        }
    }

    private void deserializeUpgrades(CompoundNBT upgradesNBT) {
        for (String key : upgradesNBT.func_150296_c()) {
            ResourceLocation resourceLocation = new ResourceLocation(key);
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBT(upgradesNBT.func_74775_l(key));
            this.upgrades.put(resourceLocation, upgrade);
            if (!upgradeType.isEngine) continue;
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("health", ((Integer)this.field_70180_af.func_187225_a(HEALTH)).intValue());
        compound.func_74768_a("max_health", ((Integer)this.field_70180_af.func_187225_a(MAX_HEALTH)).intValue());
        compound.func_74776_a("max_speed", ((Float)this.field_70180_af.func_187225_a(MAX_SPEED)).floatValue());
        compound.func_74778_a("material", (String)this.field_70180_af.func_187225_a(MATERIAL));
        compound.func_218657_a("upgrades", (INBT)this.getUpgradesNBT());
    }

    private CompoundNBT getUpgradesNBT() {
        CompoundNBT upgradesNBT = new CompoundNBT();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.func_218657_a(upgrade.getType().getRegistryName().toString(), (INBT)upgrade.serializeNBT());
        }
        return upgradesNBT;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return this.upgrades.containsKey(SimplePlanesUpgrades.FLOATY_BEDDING.getId());
    }

    public boolean func_241845_aY() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (MATERIAL.equals(key) && this.field_70170_p.func_201670_d()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)this.field_70180_af.func_187225_a(MATERIAL)));
            this.planksMaterial = block == null ? Blocks.field_196662_n : block;
        } else if (Q.equals(key) && this.field_70170_p.func_201670_d() && !this.func_184186_bw()) {
            if (this.field_70148_d) {
                this.lerpStepsQ = 0;
                this.setQ_Client(this.getQ());
                this.setQ_prev(this.getQ());
            } else {
                this.lerpStepsQ = 10;
            }
        }
    }

    public double func_70042_X() {
        return 0.375;
    }

    public boolean func_180431_b(DamageSource source) {
        if (source.func_94541_c()) {
            return false;
        }
        if (source.func_76347_k() && BlockTags.func_199896_a().func_199910_a(FIREPROOF_MATERIALS).func_230235_a_((Object)this.planksMaterial)) {
            return true;
        }
        if (source.func_76364_f() != null && source.func_76364_f().func_184223_x((Entity)this)) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public boolean func_230279_az_() {
        return BlockTags.field_232867_Q_.func_230235_a_((Object)this.planksMaterial);
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if ((onGroundIn || this.isOnWater()) && ((Boolean)SimplePlanesConfig.PLANE_CRASH.get()).booleanValue()) {
            double y1 = this.transformPos(new Vector3f(0.0f, 1.0f, 0.0f)).func_195900_b();
            if (y1 < Math.cos(Math.toRadians(this.getLandingAngle()))) {
                state.func_177230_c().func_180658_a(this.field_70170_p, pos, (Entity)this, (float)(this.func_213322_ci().func_72433_c() * 5.0));
            }
            this.field_70143_R = 0.0f;
        }
    }

    protected int getLandingAngle() {
        return 30;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.func_184207_aI()) {
            this.crash(distance * damageMultiplier);
        }
        return false;
    }

    public void crash(float damage) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            for (Entity entity : this.func_184188_bt()) {
                float damageMod = Math.min(1.0f, 1.0f - (float)this.getHealth() / (float)this.getMaxHealth());
                entity.func_70097_a(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage * damageMod);
            }
            this.func_70097_a(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage + 2.0f);
        }
    }

    public boolean isCreative() {
        return this.func_184179_bs() instanceof PlayerEntity && ((PlayerEntity)this.func_184179_bs()).func_184812_l_();
    }

    public boolean getOnGround() {
        return this.field_70122_E || this.onGroundTicks > 1;
    }

    public boolean isOnWater() {
        return this.field_70170_p.func_180495_p(new BlockPos(this.func_213303_ch().func_72441_c(0.0, 0.4, 0.0))).func_177230_c() == Blocks.field_150355_j;
    }

    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.isEngine && this.engineUpgrade != null) {
            return false;
        }
        return !this.upgrades.containsKey(upgradeType.getRegistryName());
    }

    public void func_70098_U() {
        super.func_70098_U();
    }

    public void func_184232_k(Entity passenger) {
        boolean b;
        super.func_184232_k(passenger);
        boolean bl = b = passenger instanceof PlayerEntity && ((PlayerEntity)passenger).func_175144_cb();
        if (this.func_184196_w(passenger) && !b) {
            this.applyYawToEntity(passenger);
        }
    }

    public void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_70034_d(entityToUpdate.func_70079_am() + this.deltaRotation);
        entityToUpdate.field_70126_B += this.deltaRotation;
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70126_B - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        float perc = this.deltaRotationTicks > 0 ? 1.0f / (float)this.deltaRotationTicks : 1.0f;
        float diff = (f1 - f) * perc;
        entityToUpdate.field_70177_z += diff;
        entityToUpdate.field_70126_B += diff;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    public Vector3d func_230268_c_(LivingEntity livingEntity) {
        return super.func_230268_c_(livingEntity);
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.getItem().func_190903_i();
        CompoundNBT compound = new CompoundNBT();
        this.func_213281_b(compound);
        compound.func_74768_a("health", ((Integer)this.field_70180_af.func_187225_a(MAX_HEALTH)).intValue());
        compound.func_74757_a("Used", true);
        itemStack.func_77983_a("EntityTag", (INBT)compound);
        return itemStack;
    }

    protected Item getItem() {
        return (Item)SimplePlanesItems.PLANE_ITEM.get();
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.lerpStepsQ = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
        }
        if (this.lerpStepsQ > 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(MathUtil.lerpQ(1.0f / (float)this.lerpStepsQ, this.getQ_Client(), this.getQ()));
            --this.lerpStepsQ;
        } else if (this.lerpStepsQ == 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(this.getQ());
            --this.lerpStepsQ;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.func_226277_ct_() && y == this.func_226278_cu_() && z == this.func_226281_cx_()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = 10;
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        double d0 = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        double d1 = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        this.field_70142_S = d0;
        this.field_70137_T = y;
        this.field_70136_U = d1;
        this.func_70107_b(d0, y, d1);
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = pitch % 360.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw()) {
            this.mountMessage = true;
            if (this.lerpSteps > 0) {
                this.lerpSteps = 0;
                this.func_70080_a(this.lerpX, this.lerpY, this.lerpZ, this.field_70177_z, this.field_70125_A);
            }
        }
    }

    public PlayerEntity getPlayer() {
        if (this.func_184179_bs() instanceof PlayerEntity) {
            return (PlayerEntity)this.func_184179_bs();
        }
        return null;
    }

    private void setRockingTicks(int rockingTicks) {
        this.field_70180_af.func_187227_b(ROCKING_TICKS, (Object)rockingTicks);
    }

    private int getRockingTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ROCKING_TICKS);
    }

    private void updateRocking() {
        if (this.field_70170_p.field_72995_K) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = MathHelper.func_76131_a((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    Vector3d vector3d = this.func_213322_ci();
                    this.func_213293_j(vector3d.field_72450_a, this.func_205708_a(PlayerEntity.class) ? 2.7 : 0.6, vector3d.field_72449_c);
                }
                this.rocking = false;
            }
        }
    }

    public float getRockingAngle(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.prevRockingAngle, (float)this.rockingAngle);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_70180_af.func_187227_b(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_SINCE_HIT);
    }

    public void setDamageTaken(float damageTaken) {
        this.field_70180_af.func_187227_b(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE_TAKEN)).floatValue();
    }

    public double getCameraDistanceMultiplayer() {
        return 1.0;
    }

    public void writeUpdateUpgradePacket(ResourceLocation upgradeID, PacketBuffer buffer) {
        buffer.func_150787_b(this.func_145782_y());
        buffer.func_192572_a(upgradeID);
        this.upgrades.get(upgradeID).writePacket(buffer);
    }

    public void readUpdateUpgradePacket(ResourceLocation upgradeID, PacketBuffer buffer, boolean newUpgrade) {
        if (newUpgrade) {
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
        }
        this.upgrades.get(upgradeID).readPacket(buffer);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.upgrades != null) {
            for (Upgrade upgrade : this.upgrades.values()) {
                LazyOptional lazyOptional = upgrade.getCapability(cap, side);
                if (!lazyOptional.isPresent()) continue;
                return lazyOptional;
            }
        }
        return super.getCapability(cap, side);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        Collection<Upgrade> upgrades = this.upgrades.values();
        buffer.func_150787_b(upgrades.size());
        for (Upgrade upgrade : upgrades) {
            ResourceLocation upgradeID = upgrade.getType().getRegistryName();
            buffer.func_192572_a(upgradeID);
            upgrade.writePacket(buffer);
        }
    }

    public void readSpawnData(PacketBuffer additionalData) {
        int upgradesSize = additionalData.func_150792_a();
        for (int i = 0; i < upgradesSize; ++i) {
            ResourceLocation upgradeID = additionalData.func_192575_l();
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
            upgrade.readPacket(additionalData);
        }
    }

    public void removeUpgrade(ResourceLocation upgradeID) {
        Upgrade upgrade = this.upgrades.remove(upgradeID);
        if (upgrade != null) {
            upgrade.dropItems();
            upgrade.remove();
            if (!this.field_70170_p.field_72995_K) {
                PlaneNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new SUpgradeRemovedPacket(upgradeID, this.func_145782_y()));
            }
        }
    }

    protected static class TempMotionVars {
        public float moveForward;
        public double turnThreshold;
        public float moveStrafing;
        public boolean passengerSprinting;
        double maxSpeed;
        double maxPushSpeed;
        double takeOffSpeed;
        float maxLift;
        double liftFactor;
        double gravity;
        double drag;
        double dragMul;
        double dragQuad;
        float push;
        float groundPush;
        float passiveEnginePush;
        float motionToRotation;
        float pitchToMotion;
        float yawMultiplayer;

        public TempMotionVars() {
            this.reset();
        }

        public void reset() {
            this.moveForward = 0.0f;
            this.turnThreshold = 0.0;
            this.moveStrafing = 0.0f;
            this.passengerSprinting = false;
            this.maxSpeed = 3.0;
            this.takeOffSpeed = 0.3;
            this.maxLift = 2.0f;
            this.liftFactor = 10.0;
            this.gravity = -0.03;
            this.drag = 0.001;
            this.dragMul = 5.0E-4;
            this.dragQuad = 0.001;
            this.push = 0.06f;
            this.groundPush = 0.01f;
            this.passiveEnginePush = 0.025f;
            this.motionToRotation = 0.05f;
            this.pitchToMotion = 0.2f;
            this.yawMultiplayer = 0.5f;
        }
    }
}

